package com.burhanstore.neonbubblequest.Utils.monetize

import android.annotation.SuppressLint
import android.app.Activity
import android.util.Log
import com.burhanstore.neonbubblequest.Utils.AppString
import com.burhanstore.neonbubblequest.Utils.DialogManager.dismissDialog
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.facebook.ads.*

@SuppressLint("StaticFieldLeak")
object Facebook_Ad {

    private const val TAG = "Facebook_Ad"
    private var rewardedInterstitialAd: RewardedInterstitialAd? = null
    private var placementId: String = ""
    private var isInitialized = false
    private var isAdLoaded = false
    private var isAdCompleted = false
    private lateinit var activity: Activity

    private var onAdCompleteCallback: (() -> Unit)? = null
    private var onAdFailedCallback: (() -> Unit)? = null
    private var onAdClickedCallback: (() -> Unit)? = null

    fun initialize(
        activity: Activity,
        isTestMode: Boolean = false,
        onInitialized: (() -> Unit)? = null
    ) {
        if (isInitialized) return

        this.activity = activity

        // Read ad unit ID from JSON settings
        val jsonReader =
            AppString.JsonReader(UserManager.getInstance(activity).getSetting()?.ad_unit ?: "")
        this.placementId = jsonReader.get("fb_rewardid")

        // Initialize Audience Network
        AudienceNetworkAds.initialize(activity)
        AdSettings.setTestMode(true)
        AdSettings.setIntegrationErrorMode(AdSettings.IntegrationErrorMode.INTEGRATION_ERROR_CRASH_DEBUG_MODE)

        Log.d(TAG, "Facebook Audience Network initialized" + this.placementId)
        isInitialized = true
        onInitialized?.invoke()

        loadAd()

    }

    fun loadAd() {
        if (!isInitialized) return

        rewardedInterstitialAd = RewardedInterstitialAd(activity, placementId)
        isAdLoaded = false

        rewardedInterstitialAd?.loadAd(
            rewardedInterstitialAd?.buildLoadAdConfig()
                ?.withAdListener(object : RewardedInterstitialAdListener {
                    override fun onError(ad: Ad?, adError: AdError?) {
                        Log.e(TAG, "Facebook Ad Load Error: ${adError?.errorMessage}")
                        isAdLoaded = false
                        onAdFailedCallback?.invoke()
                        clearCallbacks()

                        // Retry after 10 seconds if failed
                        activity.window?.decorView?.postDelayed({ loadAd() }, 10000)
                    }

                    override fun onAdLoaded(ad: Ad?) {
                        Log.d(TAG, "Facebook Ad Loaded Successfully")
                        isAdLoaded = true
                    }

                    override fun onAdClicked(ad: Ad?) {
                        Log.d(TAG, "Facebook Ad Clicked")
                        onAdClickedCallback?.invoke()
                    }

                    override fun onLoggingImpression(ad: Ad?) {
                        Log.d(TAG, "Facebook Ad Impression Logged")
                        dismissDialog()
                    }

                    override fun onRewardedInterstitialCompleted() {
                        Log.d(TAG, "Facebook Ad Completed")
                        isAdCompleted = true
                    }

                    override fun onRewardedInterstitialClosed() {
                        Log.d(TAG, "Facebook Ad Closed")

                        if (isAdCompleted) {
                            Log.d(TAG, "Reward granted (Ad Completed)")
                            onAdCompleteCallback?.invoke()
                        } else {
                            Log.d(TAG, "Ad closed before completion (No reward)")
                            onAdFailedCallback?.invoke()
                        }

                        dismissDialog()
                        clearCallbacks()
                        isAdCompleted = false

                        // Always preload next ad
                        loadAd()
                    }
                })?.build()
        )
    }

    fun showAd(
        onAdComplete: () -> Unit = {},
        onAdFailed: (() -> Unit)? = null,
        onAdClicked: (() -> Unit)? = null
    ) {
        onAdCompleteCallback = onAdComplete
        onAdFailedCallback = onAdFailed
        onAdClickedCallback = onAdClicked

        if (rewardedInterstitialAd != null && rewardedInterstitialAd!!.isAdLoaded) {
            rewardedInterstitialAd?.show()
        } else {
            Log.w(TAG, "Facebook Ad not loaded — retrying...")
            onAdFailedCallback?.invoke()
            clearCallbacks()
            loadAd()
        }
    }

    private fun clearCallbacks() {
        onAdCompleteCallback = null
        onAdFailedCallback = null
        onAdClickedCallback = null
    }
}
